ALARM SYSTEM 
============

Alarm is expected to be used by many parts of the system. Appointment is one of the uses.

Alarm SQL Table per mailbox
----

  * date (indexed)
  * mail_item_id (foreign key constraint, cascade delete)
  * action (metadata blob)

Alarm Thread
----

  * On Startup:
    * Initialize static table of IAlarmHandlers
      * e.g. AppointmentAlarmHandler, MessageFollowupAlarmHandler
    * FOR EACH MAILBOX:
      *  EXECUTE alarms for mailbox (see below)
      *  select NEXT alarm (1st one not-executed) from mailbox's alarm table
      *  add to global sorted systemwide tree <key:TIME, value:MAILBOXID> 
         of upcoming alarms
  * While (system is up):
    * Sleep until NEXT-ALARM-TIME
    * Foreach NEW-ALARM:
      * update Upcoming Alarm list (put this new one on front if necessary)    
    * For every entry on upcoming alarm list where the time has passed
      * EXECUTE alarms for mailbox

When a new alarm is created
----

  * Add to Mailbox's alarm table
  * Put on "New Alarm Queue" for Alarm Thread (use queue to avoid deadlocking with running Alarms)
  * Wake up alarm thread
     
To EXECUTE alarms for mailbox
----

  * Select all rows from alarm table with time <= now
  * Pass row data to the system alarm handler registry 
    * Registry instantiates correct handler and executes
    * if executed SUCCESSFULLY:
      * Delete row from alarm table
    * else if Alarm PENDING (ie it requires client connected):
      * Add to systemwide Pending Mailbox Alarm list 
        (mailboxes which have alarms which must be run when the client connects) 

When a MAILBOX logs on (hook into creation of SESSION object)
----

   If MAILBOX is in Pending Mailbox Alarm List
      select everything in mailbox's alarm table < now
      execute the alarms (in time order) 
         if successful, remove alarm from table 
      remove mailbox from Pending Mailbox Alarm list


Alarm types
----

1. audio + display
   need to have a sound resource and a text message.
   this may be a url pointing to the zimbra server.
   how to provision sound resources? is this system-wide or per-mailbox?
   
   * dismissible attribute: true/false
   * repetition count/interval: can be defined
   
2. display
   need to have a text message
   what about images?
   
   * dismissible attribute: true/false
   * repetition count/interval: can be defined
   
3. email
   need to have recipients, subject, message body
   
   * dismissible attribute: n/a
   * repetition count/interval: can be defined? (this opens up to abuse)
         
audio alone is probably not good usability-wise.
         
Some alarms types will need to be "dismissible" that is they don't get removed from 
the pending-alarm-list until the someone (ie the client) says it is OK to dismiss them....
basically you want that so you can be sure that the alarm actually gets seen by the user.

Comments
--------

Alarm table:

  1. The Date is there so we can keep a list of the alarm and know when to trigger them.

  2. The mail_item_id is there to associate the alarm with any mail-item.  
	 This doesn't have to be an appointment, it could be any mail-item.  
	 The major reason for this column is for deletion -- so we have a way of deleting alarms 
	 if the target (Appointment, Message) gets deleted.

  3. The Action is a metadata blob -- there will be some systemwide Factory which reads the metadata, 
	gets the type, and instantiates the proper subclass of IAlarmHandler -- 
	the IAlarmHandler subclass has an overloaded method (ie "Run") that has the alarm logic itself....
	such as code to deal with notifying the client that it needs to put up a Popup or whatever...

Client side actions
----

The client doesn't have to have a list of alarms --- we could just wait until the alarm executes on the server 
and then have it post a message into the list of pending notifications for the client -- 
the next time the client did an operation (or issued a NOP) the server would include the alarm info in the response.  

If we want to have the client track the upcoming alarms, then we just do a select in the alarm table on 
session creation and send the client a list of upcoming alarms which have popups....

If we don't hand a list of future alarms to client for the client to track and activate, we'll have
a delay of at most polling interval, which is 5 minutes right now.

SOAP 
----

Create new alarms:

````
<CreateAlarmRequest>
  <a type="audio|display|email" time="{time}" item="{mail item id}">
    [<res url="audio.wav"/>]
    [<rep n="count" intval="interval"/>]
    [<dismissible="0|1"/>]
    <msg>
      [<e a="email addr">*
      <su>subject</su>]
      <content>...</content>
    </msg>
  </a>
</CreateAlarmRequest>

<CreateAlarmResponse>
</CreateAlarmResponse>
````

Modify an alarm:

````
<ModifyAlarmRequest>
  <!-- same as CreateAlarmRequest. 
    The alarm with the given time and mail item id will be modified. 
  -->
</ModifyAlarmRequest>
````

Get an alarm:

````
<GetAlarmRequest>
  <a time="{time}" item="{mail item id}"/>
</GetAlarmRequest>

<GetAlarmResponse>
  <a ...>
    <!-- same as CreateAlarmRequest -->
  </a>
</GetAlarmResponse>
````

Get alarms:

````
<GetAlarmsRequest>
  <a s="{start time}" e="{end time}"/>
</GetAlarmsRequest>

<GetAlarmsResponse>
  <a ...>
    <!-- same as CreateAlarmRequest -->
  </a>*
</GetAlarmsResponse>  
````

In SoapHeader of soap responses, we need to add the following section to <notify>:

````
<alarm>
  <a ...>
  </a>*
</alarm>
````

to indicate the list of alarms that need to be executed on the client.
(Assuming we put due alarms onto pending list and wait for the client to retrieve at
next operation.)
